-- events for main menu


function OnLoad ()
	SetProperty ("/TalismanCompleted:enter_trans_duration", 0.3);
	SetProperty ("/TalismanCompleted:leave_trans_duration", 0.3);
	CacheSound ("ui/sfx/panel_move.ogg");
	CacheSound ("music/amulet.ogg");
end;


function OnEnter ()

	PlaySound ("ui/sfx/panel_move.ogg");
	PlaySound ("music/amulet.ogg");
	
	if (Azkend_AutoplayerActive ()) then
		OnClick ("Ok");
	end;	
end;

function OnLeave ()
    
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Ok") then
	    	PlaySound ("ui/sfx/panel_move.ogg");
				PopScreen ();
	end;

end;


function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("panel:position_offset.y", (1-trans) * 200);
	SetProperty ("panel:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));

end;

function OnDraw ()

end;
